/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.ast;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.ast.ClassifyingNodeTracker;
import icyllis.flexmark.util.ast.Document;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.ast.NodeTracker;
import icyllis.flexmark.util.ast.NodeVisitorBase;
import icyllis.flexmark.util.collection.CopyOnWriteRef;
import icyllis.flexmark.util.collection.OrderedMap;
import icyllis.flexmark.util.collection.OrderedSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class NodeClassifierVisitor
extends NodeVisitorBase
implements NodeTracker {
    private final OrderedMap<Class<?>, Set<Class<?>>> exclusionMap;
    private final OrderedSet<Class<?>> exclusionSet;
    private final HashMap<Integer, BitSet> nodeAncestryMap;
    private final Stack<BitSet> nodeAncestryBitSetStack = new Stack();
    private final CopyOnWriteRef<BitSet> nodeAncestryBitSet = new CopyOnWriteRef<BitSet>(new BitSet(), value -> value != null ? (BitSet)value.clone() : new BitSet());
    private static final BitSet EMPTY_SET = new BitSet();
    private boolean isClassificationDone = false;
    private final ClassifyingNodeTracker classifyingNodeTracker;

    public NodeClassifierVisitor(Map<Class<? extends Node>, Set<Class<?>>> exclusionMap) {
        this.classifyingNodeTracker = new ClassifyingNodeTracker(this, exclusionMap);
        this.exclusionMap = this.classifyingNodeTracker.getExclusionMap();
        this.nodeAncestryMap = this.classifyingNodeTracker.getNodeAncestryMap();
        this.exclusionSet = this.classifyingNodeTracker.getExclusionSet();
    }

    @NotNull
    public ClassifyingNodeTracker classify(@NotNull Node node) {
        assert (!this.isClassificationDone);
        this.visit(node);
        this.isClassificationDone = true;
        return this.classifyingNodeTracker;
    }

    @Override
    public void visit(@NotNull Node node) {
        this.visitChildren(node);
    }

    @Override
    public void nodeRemoved(@NotNull Node node) {
    }

    @Override
    public void nodeRemovedWithChildren(@NotNull Node node) {
    }

    @Override
    public void nodeRemovedWithDescendants(@NotNull Node node) {
    }

    @Override
    public void nodeAddedWithChildren(@NotNull Node node) {
        this.nodeAdded(node);
    }

    @Override
    public void nodeAddedWithDescendants(@NotNull Node node) {
        this.nodeAdded(node);
    }

    @Override
    public void nodeAdded(@NotNull Node node) {
        if (this.isClassificationDone) {
            if (node.getParent() == null) {
                throw new IllegalStateException("Node must be inserted into the document before calling node tracker nodeAdded functions");
            }
            if (!(node.getParent() instanceof Document)) {
                int parentIndex = this.classifyingNodeTracker.getItems().indexOf(node.getParent());
                if (parentIndex == -1) {
                    throw new IllegalStateException("Parent node: " + node.getParent() + " of " + node + " is not tracked, some post processor forgot to call tracker.nodeAdded().");
                }
                BitSet ancestorBitSet = this.nodeAncestryMap.get(parentIndex);
                this.nodeAncestryBitSet.setValue(ancestorBitSet);
            }
            this.nodeAncestryBitSetStack.clear();
            this.visit(node);
        }
    }

    void pushNodeAncestry() {
        if (!this.exclusionMap.isEmpty()) {
            this.nodeAncestryBitSetStack.push(this.nodeAncestryBitSet.getImmutable());
        }
    }

    void popNodeAncestry() {
        this.nodeAncestryBitSet.setValue(this.nodeAncestryBitSetStack.pop());
    }

    boolean updateNodeAncestry(Node node, CopyOnWriteRef<BitSet> nodeAncestryBitSet) {
        if (!this.exclusionMap.isEmpty() && !(node instanceof Document)) {
            BitSet oldBitSet;
            BitSet bitSet = nodeAncestryBitSet.getPeek();
            assert (bitSet != null);
            int index = this.classifyingNodeTracker.getItems().indexOf(node);
            if (index == -1) {
                throw new IllegalStateException("Node: " + node + " is not tracked, some post processor forgot to call tracker.nodeAdded().");
            }
            if (this.exclusionSet != null && !this.exclusionSet.isEmpty()) {
                for (Class clazz : this.exclusionSet) {
                    if (!clazz.isInstance(node)) continue;
                    int i = this.exclusionSet.indexOf(clazz);
                    assert (i != -1);
                    if (bitSet.get(i)) continue;
                    bitSet = nodeAncestryBitSet.getMutable();
                    assert (bitSet != null);
                    bitSet.set(i);
                }
            }
            if (this.isClassificationDone && this.nodeAncestryBitSetStack.size() > 1 && (oldBitSet = this.nodeAncestryMap.get(index)) != null && oldBitSet.equals(bitSet)) {
                return false;
            }
            if (!bitSet.isEmpty()) {
                this.nodeAncestryMap.put(index, nodeAncestryBitSet.getImmutable());
            }
        }
        return true;
    }

    @Override
    public void visitChildren(@NotNull Node parent) {
        if (!this.isClassificationDone && !(parent instanceof Document)) {
            this.classifyingNodeTracker.nodeAdded(parent);
        }
        if (parent.getFirstChild() != null) {
            this.pushNodeAncestry();
            if (this.updateNodeAncestry(parent, this.nodeAncestryBitSet)) {
                super.visitChildren(parent);
            }
            this.popNodeAncestry();
        } else {
            this.updateNodeAncestry(parent, this.nodeAncestryBitSet);
        }
    }
}

